/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.filesystem.secureftp;

import com.aptana.core.io.efs.VirtualFile;
import com.aptana.core.io.vfs.IConnectionFileManager;
import com.aptana.filesystem.secureftp.IFTPSConnectionFileManager;
import com.aptana.filesystem.secureftp.internal.FTPSConnectionFileManager;
import com.aptana.ide.core.io.ConnectionContext;
import com.aptana.ide.core.io.CoreIOPlugin;
import java.net.URI;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class FTPSFileSystem
extends FileSystem {
    private static Map<String, IFTPSConnectionFileManager> fgConnectionManagers = new WeakHashMap<String, IFTPSConnectionFileManager>();

    public IFileStore getStore(URI uri) {
        String host = uri.getHost();
        int port = uri.getPort();
        String path = uri.getPath();
        String userInfo = uri.getUserInfo();
        String login = "";
        char[] password = "".toCharArray();
        if (userInfo != null && userInfo.length() > 0) {
            if (userInfo.contains(":")) {
                String[] parts = userInfo.split(":");
                login = parts[0];
                if (parts.length > 1) {
                    password = parts[1].toCharArray();
                }
            } else {
                login = userInfo;
            }
        }
        if (login == null || login.length() == 0) {
            login = "anonymous";
        }
        if (port == -1) {
            port = 21;
        }
        IFTPSConnectionFileManager connectionFileManager = this.getConnectionFileManager(host, port, path, login, password);
        return new VirtualFile((IConnectionFileManager)connectionFileManager, uri, Path.fromPortableString((String)path));
    }

    protected synchronized IFTPSConnectionFileManager getConnectionFileManager(String host, int port, String path, String login, char[] password) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(login);
        if (password != null && password.length > 0) {
            stringBuilder.append(':');
            stringBuilder.append(password);
        }
        stringBuilder.append('@');
        stringBuilder.append(host);
        stringBuilder.append(':');
        stringBuilder.append(port);
        String key = stringBuilder.toString();
        IFTPSConnectionFileManager connectionFileManager = fgConnectionManagers.get(key);
        if (connectionFileManager == null) {
            ConnectionContext context;
            connectionFileManager = (IFTPSConnectionFileManager)super.getAdapter(IFTPSConnectionFileManager.class);
            if (connectionFileManager == null && Platform.getAdapterManager().hasAdapter((Object)this, IFTPSConnectionFileManager.class.getName())) {
                connectionFileManager = (IFTPSConnectionFileManager)Platform.getAdapterManager().loadAdapter((Object)this, IFTPSConnectionFileManager.class.getName());
            }
            if (connectionFileManager == null) {
                connectionFileManager = new FTPSConnectionFileManager();
            }
            if ((context = CoreIOPlugin.getConnectionContext((Object)((Object)this))) == null) {
                context = new ConnectionContext();
            }
            context.put((Object)"no_password_prompt", (Object)true);
            context.put((Object)"quick_connect", (Object)true);
            CoreIOPlugin.setConnectionContext((Object)connectionFileManager, (ConnectionContext)context);
            connectionFileManager.init(host, port, (IPath)Path.ROOT, login, password, true, true, "BINARY", "US-ASCII", null, true, false);
            fgConnectionManagers.put(key, connectionFileManager);
        }
        return connectionFileManager;
    }
}

